#include <p30fxxxx.h>
#include <incap.h>

/* These devices support Input Capture 7 and Input Capture 8 */
#if defined (__dsPIC30F2010__) || defined (__dsPIC30F3010__) || defined (__dsPIC30F4012__) || \
    defined (__dsPIC30F3011__) || defined (__dsPIC30F4011__) || defined (__dsPIC30F6010__) || \
    defined (__dsPIC30F5011__) || defined (__dsPIC30F6011__) || defined (__dsPIC30F6012__) || \
    defined (__dsPIC30F5013__) || defined (__dsPIC30F6013__) || defined (__dsPIC30F6014__) || \
    defined (__dsPIC30F4013__) || defined (__dsPIC30F5015__)

/********************************************************************
*    Function Name:  ConfigIntCapture7                              *
*    Description:    Set the Enable Interrupts and Interrupt        *
*                    Priorites  to the Interrupt Control and        *
*                    Interrupt Priority Register respectively       *
*    Parameters:     unsigned int config                            *
*    Return Value:   None                                           *
********************************************************************/

void ConfigIntCapture7(unsigned int config)
{
    IFS1bits.IC7IF = 0;                    /* Clear IF bit */
    IPC4bits.IC7IP = (config & 0x0007);    /*assigning Interrupt Priority
                                                              to IPC*/
    IEC1bits.IC7IE = (config & 0x0008)>>3; /*assigns Interrupt Enable/
                                                            Disable */
}

#endif 
